<?php
require_once 'config/config.php';

session_start();

// السماح فقط للمستخدم رقم 1
if (!isset($_SESSION['user_id']) || $_SESSION['user_id'] != 1) {
    header('Location: users.php');
    exit;
}

if (isset($_GET['id']) && is_numeric($_GET['id'])) {
    $userId = (int) $_GET['id'];

    // لا يُسمح بحذف المستخدم رقم 1 نهائيًا
    if ($userId === 1) {
        header('Location: users.php');
        exit;
    }

    $stmt = $conn->prepare("DELETE FROM users WHERE id = ?");
    $stmt->bind_param("i", $userId);

    if ($stmt->execute()) {
        header('Location: users.php?msg=deleted');
        exit;
    } else {
        echo "Error deleting user: " . $stmt->error;
    }
} else {
    header('Location: users.php');
    exit;
}
?>
