<?php
require_once 'config/config.php';
session_start();

$success = '';
$error = '';
$voucher_id = $_GET['id'] ?? null;

// جلب بيانات الفاوتشر
if ($voucher_id) {
    $result = $conn->prepare("SELECT * FROM vouchers WHERE id = ?");
    $result->bind_param("i", $voucher_id);
    $result->execute();
    $voucher = $result->get_result()->fetch_assoc();
    if (!$voucher) {
        $error = "Voucher not found.";
    }
}

// جلب الشروط من قاعدة البيانات
$termsContent = '';
$termsResult = $conn->query("SELECT content FROM terms_conditions LIMIT 1");
if ($termsResult && $termsResult->num_rows > 0) {
    $termsContent = $termsResult->fetch_assoc()['content'];
}

// عند الضغط على حفظ
if ($_SERVER['REQUEST_METHOD'] === 'POST' && $voucher_id) {
    $hotel_name       = $_POST['hotel_name'] ?? '';
    $city             = $_POST['city'] ?? '';
    $check_in_date    = $_POST['check_in_date'] ?? '';
    $check_out_date   = $_POST['check_out_date'] ?? '';
    $room_type        = $_POST['room_type'] ?? '';
    $rooms_count      = $_POST['rooms_count'] ?? 0;
    $guests_per_room  = $_POST['guests_per_room'] ?? 0;
    $customer_name    = $_POST['customer_name'] ?? '';
    $terms = $_POST['terms'] ?? '';

    $status           = $_POST['status'] ?? '';
    $view             = $_POST['view'] ?? '';
    $room_level       = $_POST['room_level'] ?? '';
    $meal_plan        = $_POST['meal_plan'] ?? '';

    // حساب عدد الليالي
    $date1 = new DateTime($check_in_date);
    $date2 = new DateTime($check_out_date);
    $nights = $date1->diff($date2)->days;

    // تحديث البيانات
    $stmt = $conn->prepare("UPDATE vouchers SET 
        hotel_name=?, city=?, check_in_date=?, check_out_date=?, nights=?, 
        room_type=?, rooms_count=?, guests_per_room=?, 
        customer_name=?, status=?, view=?, room_level=?, meal_plan=?, terms=?
        WHERE id=?");

    $stmt->bind_param("ssssisisssssssi",
        $hotel_name, $city, $check_in_date, $check_out_date, $nights,
        $room_type, $rooms_count, $guests_per_room,
        $customer_name, $status, $view, $room_level, $meal_plan, $terms,
        $voucher_id
    );



    if ($stmt->execute()) {
        $success = $lang['voucher_updated'] ?? 'Voucher updated successfully.';
        // إعادة تحميل البيانات بعد التحديث
        $result = $conn->prepare("SELECT * FROM vouchers WHERE id = ?");
        $result->bind_param("i", $voucher_id);
        $result->execute();
        $voucher = $result->get_result()->fetch_assoc();
    } else {
        $error = $lang['voucher_failed'] ?? 'Failed to update voucher.';
    }
}
?>

<?php include 'header.php'; ?>
<div class="main-content p-4" style="flex: 1;">

<h2 class="mb-4"><?= $lang['edit_voucher'] ?? 'Edit Voucher' ?></h2>

<?php if ($error): ?>
    <div class="alert alert-danger"><?= $error ?></div>
<?php elseif ($success): ?>
    <div class="alert alert-success"><?= $success ?></div>
<?php endif; ?>

<?php if ($voucher): ?>
<form method="POST">
    <div class="row mb-3">
        <div class="col-md-3">
            <label class="form-label"><?= $lang['hotel_name'] ?></label>
            <input type="text" name="hotel_name" class="form-control" value="<?= htmlspecialchars($voucher['hotel_name']) ?>" required>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['city'] ?></label>
            <input type="text" name="city" class="form-control" value="<?= htmlspecialchars($voucher['city']) ?>" required>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['check_in'] ?></label>
            <input type="date" name="check_in_date" class="form-control" value="<?= $voucher['check_in_date'] ?>" required>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['check_out'] ?></label>
            <input type="date" name="check_out_date" class="form-control" value="<?= $voucher['check_out_date'] ?>" required>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-3">
            <label class="form-label"><?= $lang['rooms_count'] ?></label>
            <input type="number" name="rooms_count" class="form-control" value="<?= $voucher['rooms_count'] ?>" required>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['guests_per_room'] ?></label>
            <input type="number" name="guests_per_room" class="form-control" value="<?= $voucher['guests_per_room'] ?>" required>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['customer_name'] ?></label>
            <input type="text" name="customer_name" class="form-control" value="<?= htmlspecialchars($voucher['customer_name']) ?>" required>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['status'] ?></label>
            <select name="status" class="form-select" required>
                <option value="Confirmed" <?= $voucher['status'] == 'Confirmed' ? 'selected' : '' ?>><?= $lang['confirmed'] ?></option>
                <option value="Hold" <?= $voucher['status'] == 'Hold' ? 'selected' : '' ?>><?= $lang['hold'] ?></option>
                <option value="Cancelled" <?= $voucher['status'] == 'Cancelled' ? 'selected' : '' ?>><?= $lang['cancelled'] ?></option>
            </select>
        </div>
    </div>
<div class="row mb-3">
        <div class="col-md-3">
            <label class="form-label"><?= $lang['room_type'] ?></label>
            <select name="room_type" class="form-select" required>
                <?php
                $types = ['room_single', 'room_double', 'room_triple', 'room_quad', 'room_quintuple', 'room_suite', 'room_two_living'];
                foreach ($types as $type) {
                    $val = $lang[$type];
                    echo "<option value=\"$val\" " . ($voucher['room_type'] === $val ? 'selected' : '') . ">$val</option>";
                }
                ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['view'] ?></label>
            <select name="view" class="form-select" required>
                <?php
                $views = ['city_view', 'haram_view', 'kaaba_view', 'sea_view', 'garden_view', 'pool_view'];
                foreach ($views as $view) {
                    $val = $lang[$view];
                    echo "<option value=\"$val\" " . ($voucher['view'] === $val ? 'selected' : '') . ">$val</option>";
                }
                ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['room_level'] ?></label>
            <select name="room_level" class="form-select" required>
                <?php
                $levels = ['standard_room', 'deluxe_room', 'superior_room'];
                foreach ($levels as $level) {
                    $val = $lang[$level];
                    echo "<option value=\"$val\" " . ($voucher['room_level'] === $val ? 'selected' : '') . ">$val</option>";
                }
                ?>
            </select>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['meal_plan'] ?></label>
            <select name="meal_plan" class="form-select" required>
                <?php
                $meals = ['b_b', 'r_o', 'h_b', 'f_b', 'ai', 'ai_s', 'ai_h'];
                foreach ($meals as $meal) {
                    $val = strtoupper(str_replace('_', '.', $meal));
                    echo "<option value=\"$val\" " . ($voucher['meal_plan'] === $val ? 'selected' : '') . ">{$lang[$meal]}</option>";
                }
                ?>
            </select>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-3">
            <label class="form-label"><?= $lang['booking_number'] ?></label>
            <input type="text" class="form-control" value="<?= htmlspecialchars($voucher['booking_number']) ?>" disabled>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['entered_by'] ?></label>
            <input type="text" class="form-control" value="<?= htmlspecialchars($_SESSION['user_name']) ?>" disabled>
        </div>
        <div class="col-md-3">
            <label class="form-label"><?= $lang['voucher_date'] ?></label>
            <input type="text" class="form-control" value="<?= htmlspecialchars($voucher['voucher_date']) ?>" disabled>
        </div>
    </div>

<div class="mb-3">
    <label class="form-label"><?= $lang['terms_conditions'] ?></label>
<textarea name="terms" class="form-control" rows="5" readonly><?= htmlspecialchars($voucher['terms'] ?? $termsContent ?? '') ?></textarea>
</div>


    <button type="submit" class="btn btn-success"><?= $lang['save'] ?></button>
</form>
<?php endif; ?>
</div>
<?php include 'includes/footer.php'; ?>
