<?php
require_once 'config/config.php';
require_once 'vendor/autoload.php'; // مكتبة PHPMailer
session_start();

// اللغة
$lang_code = $_SESSION['language'] ?? 'english';
require_once "languages/$lang_code.php";

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $email = $username . '@bebektravel.com';
    
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {
        $code = rand(1000, 9999);
        $_SESSION['reset_email'] = $email;
        $_SESSION['verification_code'] = $code;

        // إعداد PHPMailer
        $mail = new PHPMailer(true);

        try {
            $mail->isSMTP();
            $mail->Host       = 'm-emp.com';                  // ✅ SMTP من إعداداتك
            $mail->SMTPAuth   = true;
            $mail->Username   = 'bebek@m-emp.com';
            $mail->Password   = 'Silver002@@';
            $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;  // ✅ SSL
            $mail->Port       = 465;                          // ✅ المنفذ الصحيح

            $mail->setFrom('bebek@m-emp.com', 'Marshal Travel');
            $mail->addAddress($email);

            $mail->isHTML(true);
            $mail->Subject = 'Your Verification Code';
            $mail->Body    = "<p>Your verification code is:</p><h2>$code</h2>";

            $mail->send();

            header("Location: verify_code.php");
            exit;

        } catch (Exception $e) {
            $message = "<div class='alert alert-danger'>Mailer Error: {$mail->ErrorInfo}</div>";
        }

    } else {
        $message = "<div class='alert alert-danger'>{$lang['email_not_found']}</div>";
    }

    $stmt->close();
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= $lang['forgot_password'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5" style="max-width: 500px;">
    <!-- الشعار -->
    <div class="text-center mb-4">
        <img src="images/logo.png" alt="Logo" style="max-width: 150px;">
    </div>

    <h3 class="text-center"><?= $lang['forgot_password'] ?></h3>
    <?= $message ?>
    <form method="POST" class="mt-4">
        <div class="mb-3">
            <label class="form-label"><?= $lang['email'] ?></label>
<div class="input-group mb-3">
    <input type="text" name="username" class="form-control" placeholder="<?= $lang['email'] ?>" value="<?= htmlspecialchars($_POST['username'] ?? '') ?>" required>
    <span class="input-group-text">@bebektravel.com</span>
</div>

        </div>
        <button type="submit" class="btn btn-primary w-100"><?= $lang['send_code'] ?></button>
    </form>
</div>
<div class="text-center mt-3">
    <a href="auth/login.php"><?= $lang['back_to_login'] ?? 'Back to Login' ?></a>
</div>


<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
