<?php
require_once 'config/config.php';
require_once 'header.php';

// تحميل ملف اللغة
$lang_code = $_SESSION['language'] ?? 'english';
$lang_file = "languages/$lang_code.php";
if (file_exists($lang_file)) {
    require_once $lang_file;
} else {
    require_once "languages/english.php";
}
?>

<div class="main-content p-4" style="flex:1;">
    <h2 class="mb-4 text-center"><?php echo $lang['stats']['title']; ?></h2>



<div class="card mb-4">
    <div class="card-body text-center">
        <?php
        $dayKey = 'day_' . strtolower(date('l')); // e.g., day_monday
        $translatedDay = $lang[$dayKey] ?? date('l');
        $dateToday = date('Y-m-d');
        ?>
        <h5 class="mb-0"><?= $lang['today_date'] ?> <?= $translatedDay ?> - <?= $dateToday ?></h5>
    </div>
</div>

    <div class="row g-3">
<!-- أقرب تواريخ المتابعة -->
<h4 class="mt-5 mb-3"><?= $lang['stats']['upcoming_followups']; ?>:</h4>
<div class="row g-3">
    <?php
    $userId = $_SESSION['user_id'];

    $followQuery = "
        SELECT followup_date
        FROM customers_followup
        WHERE followup_date >= CURDATE()
          AND followed_up = 0
          AND closed_date IS NULL
          " . ($userId != 2 ? "AND created_by = $userId" : "") . "
        GROUP BY followup_date
        ORDER BY followup_date ASC
        LIMIT 3
    ";
    $followDates = $conn->query($followQuery);
    while ($row = $followDates->fetch_assoc()):
        $date = $row['followup_date'];
    ?>
    <div class="col-md-6 col-lg-4">
        <div class="card border-warning h-100">
            <div class="card-body">
                <h6 class="card-title"><?= $lang['stats']['upcoming_followups']; ?>: <strong><?= $date ?></strong></h6>
                <ul class="list-group list-group-flush">
                    <?php
                    $clientQuery = "
                        SELECT c.*, u.name AS user_name
                        FROM customers_followup c
                        LEFT JOIN users u ON c.created_by = u.id
                        WHERE followup_date = '$date'
                          AND followed_up = 0
                          AND closed_date IS NULL
                          " . ($userId != 2 ? "AND c.created_by = $userId" : "") . "
                    ";
                    $clients = $conn->query($clientQuery);
                    while ($c = $clients->fetch_assoc()) {
                        echo "<li class='list-group-item small'>"
                            . "<strong>" . htmlspecialchars($c['customer_name']) . "</strong> - "
                            . htmlspecialchars($c['mobile_number']) . "<br>"
                            . "<span class='badge bg-info me-1'>" . htmlspecialchars($c['trip_type']) . "</span><br>"
                            . "<small class='text-muted'>" . $lang['entered_by'] . ": " . htmlspecialchars($c['user_name']) . "</small>"
                            . "</li>";
                    }
                    ?>
                </ul>
            </div>
        </div>
    </div>
    <?php endwhile; ?>
</div>





<!-- إجمالي عدد العملاء -->
<?php
$totalCustomersResult = $conn->query("SELECT COUNT(*) AS total FROM customers_followup");
$totalCustomers = $totalCustomersResult->fetch_assoc()['total'];
?>
<h4 class="mt-5 mb-3"><?= $lang['stats']['total_customers'] ?></h4>

<div class="col-md-6 col-lg-4">
    <div class="card text-white bg-secondary h-100">
        <div class="card-body">
            <h5 class="card-title"><?= $lang['stats']['total_customers'] ?></h5>
            <p class="card-text fs-4"><?= $totalCustomers ?></p>
        </div>
    </div>
</div>

<!-- عدد العملاء لكل مستخدم -->
<?php
$customerPerUserQuery = "
    SELECT u.name, COUNT(c.id) AS count
    FROM users u
    LEFT JOIN customers_followup c ON c.created_by = u.id
    WHERE u.id != 2
    GROUP BY u.id
    ORDER BY count DESC
";
$customerUsers = $conn->query($customerPerUserQuery);
while ($row = $customerUsers->fetch_assoc()):
?>
<div class="col-md-6 col-lg-4">
    <div class="card border-secondary h-100">
        <div class="card-body">
            <h6 class="card-title"><?= $lang['stats']['customers_per_user']; ?></h6>
            <p class="mb-1"><strong><?= htmlspecialchars($row['name']) ?></strong></p>
            <p class="text-muted"><?= $lang['stats']['total_customers']; ?>: <?= $row['count'] ?></p>
        </div>
    </div>
</div>
<?php endwhile; ?>



 <!-- أقرب تواريخ الدخول -->
<h4 class="mt-5 mb-3"><?= $lang['stats']['upcoming_checkin']; ?>:</h4>
<div class="row g-3">
    <?php
    $checkinQuery = "
        SELECT check_in_date
        FROM vouchers
        WHERE check_in_date >= CURDATE()
        GROUP BY check_in_date
        ORDER BY check_in_date ASC
        LIMIT 3
    ";
    $checkinDates = $conn->query($checkinQuery);
    while ($row = $checkinDates->fetch_assoc()):
        $date = $row['check_in_date'];
    ?>
    <div class="col-md-6 col-lg-4">
        <div class="card border-info h-100">
            <div class="card-body">
                <h6 class="card-title"><?= $lang['stats']['upcoming_checkin']; ?>: <strong><?= $date ?></strong></h6>
                <ul class="list-group list-group-flush">
                    <?php
                    $vouchers = $conn->query("
                        SELECT v.*, u.name AS user_name
                        FROM vouchers v
                        LEFT JOIN users u ON v.entered_by = u.id
                        WHERE v.check_in_date = '$date'
                    ");
                    while ($v = $vouchers->fetch_assoc()) {
                        echo "<li class='list-group-item small'>";
                        echo htmlspecialchars($v['hotel_name']) . " - " . htmlspecialchars($v['customer_name']);
                        echo "<br><small class='text-muted'>" . htmlspecialchars($v['user_name']) . "</small>";
                        echo "</li>";
                    }
                    ?>
                </ul>
            </div>
        </div>
    </div>
    <?php endwhile; ?>
</div>

<!-- أقرب تواريخ المغادرة -->
<h4 class="mt-5 mb-3"><?= $lang['stats']['upcoming_checkout']; ?>:</h4>
<div class="row g-3">
    <?php
    $checkoutQuery = "
        SELECT check_out_date
        FROM vouchers
        WHERE check_out_date >= CURDATE()
        GROUP BY check_out_date
        ORDER BY check_out_date ASC
        LIMIT 3
    ";
    $checkoutDates = $conn->query($checkoutQuery);
    while ($row = $checkoutDates->fetch_assoc()):
        $date = $row['check_out_date'];
    ?>
    <div class="col-md-6 col-lg-4">
        <div class="card border-success h-100">
            <div class="card-body">
                <h6 class="card-title"><?= $lang['stats']['upcoming_checkout']; ?>: <strong><?= $date ?></strong></h6>
                <ul class="list-group list-group-flush">
                    <?php
                    $vouchers = $conn->query("
                        SELECT v.*, u.name AS user_name
                        FROM vouchers v
                        LEFT JOIN users u ON v.entered_by = u.id
                        WHERE v.check_out_date = '$date'
                    ");
                    while ($v = $vouchers->fetch_assoc()) {
                        echo "<li class='list-group-item small'>";
                        echo htmlspecialchars($v['hotel_name']) . " - " . htmlspecialchars($v['customer_name']);
                        echo "<br><small class='text-muted'>" . htmlspecialchars($v['user_name']) . "</small>";
                        echo "</li>";
                    }
                    ?>
                </ul>
            </div>
        </div>
    </div>
    <?php endwhile; ?>
</div>


        <!-- إجمالي عدد الفواتير -->
        <?php
        $totalResult = $conn->query("SELECT COUNT(*) AS total FROM vouchers");
        $totalVouchers = $totalResult->fetch_assoc()['total'];
        ?>
            <h4 class="mt-5 mb-3"><?php echo $lang['stats']['total_vouchers']; ?>:</h4>

        <div class="col-md-6 col-lg-4">
            <div class="card text-white bg-primary h-100">
                <div class="card-body">
                    <h5 class="card-title"><?= $lang['stats']['total_vouchers']; ?></h5>
                    <p class="card-text fs-4"><?= $totalVouchers ?></p>
                </div>
            </div>
        </div>

        <!-- عدد الفواتير لكل مستخدم -->
        <?php
        $query = "
            SELECT u.name, COUNT(v.id) AS count
            FROM users u
            LEFT JOIN vouchers v ON v.entered_by = u.id
                WHERE u.id != 2

            GROUP BY u.id
            ORDER BY count DESC
        ";
        $result = $conn->query($query);
        while ($row = $result->fetch_assoc()):
        ?>
        <div class="col-md-6 col-lg-4">
            <div class="card border-dark h-100">
                <div class="card-body">
                    <h6 class="card-title"><?= $lang['stats']['vouchers_per_user']; ?></h6>
                    <p class="mb-1"><strong><?= htmlspecialchars($row['name']) ?></strong></p>
                    <p class="text-muted"><?= $lang['stats']['total_vouchers']; ?>: <?= $row['count'] ?></p>
                </div>
            </div>
        </div>
        <?php endwhile; ?>
    </div>

   
</div>

<?php require_once 'includes/footer.php'; ?>
