<?php
require_once 'config/config.php';

$lang_code = $_SESSION['language'] ?? 'english';
require_once "languages/$lang_code.php";

// جلب العملاء من قاعدة البيانات
$user_id = $_SESSION['user_id'];
$whereClause = in_array($user_id, [1, 2]) ? "1" : "created_by = $user_id";

$top5 = $conn->query("
    SELECT * FROM customers_followup 
    WHERE followed_up = 0 AND $whereClause 
    ORDER BY followup_date ASC 
    LIMIT 5
");
?>

<div class="card mb-4">
    <div class="card-header">
        <h5><?= $lang['upcoming_followups'] ?? 'Upcoming Followups' ?></h5>
    </div>
    <div class="card-body p-2 table-responsive">
        <table class="table table-sm table-bordered">
            <thead>
                <tr>
                    <th><?= $lang['customer_name'] ?></th>
                    <th><?= $lang['mobile_number'] ?></th>
                        <th><?= $lang['number_of_days'] ?></th>
                        <th><?= $lang['trip_type'] ?></th>
                        <th><?= $lang['first_contact_date'] ?></th>
                    <th><?= $lang['followup_date'] ?></th>
                    
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $top5->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['customer_name']) ?></td>
                    <td><?= htmlspecialchars($row['mobile_number']) ?></td>
                    <td><?= htmlspecialchars($row['number_of_days']) ?></td>
                    <td>
                                <?php
                                    switch ($row['trip_type']) {
                                        case 'package': echo $lang['trip_package']; break;
                                        case 'hajj': echo $lang['trip_hajj']; break;
                                        case 'umrah': echo $lang['trip_umrah']; break;
                                        default: echo '-';
                                    }
                                ?>
                            </td>
                            <td><?= htmlspecialchars($row['first_contact_date']) ?></td>
                    <td><?= htmlspecialchars($row['followup_date']) ?></td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</div>
