<?php
require_once 'config/config.php';
session_start();

$lang_code = $_SESSION['language'] ?? 'english';
require_once "languages/$lang_code.php";

// التحقق من وجود الإيميل المؤهل لإعادة التعيين
if (!isset($_SESSION['reset_email'])) {
    header("Location: forgot_password.php");
    exit;
}

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $code = trim($_POST['code']);

    // تأكد أن الكود يتكون من 4 أرقام
    if (!preg_match('/^\d{4}$/', $code)) {
        $message = "<div class='alert alert-danger'>" . ($lang['invalid_code_format'] ?? 'Invalid code format') . "</div>";
    } elseif ($code == $_SESSION['verification_code']) {
        // الكود صحيح، الانتقال لتغيير كلمة السر
        $_SESSION['code_verified'] = true;
        header("Location: reset_password.php");
        exit;
    } else {
        $message = "<div class='alert alert-danger'>{$lang['invalid_code']}</div>";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= $lang['verify_code'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5" style="max-width: 500px;">
        <!-- شعار -->
    <div class="text-center mb-4">
        <img src="images/logo.png" alt="Logo" style="max-width: 150px;">
    </div>

    <h3 class="text-center"><?= $lang['verify_code'] ?></h3>
    <?= $message ?>
    <form method="POST" class="mt-4">
        <div class="mb-3">
            <label class="form-label"><?= $lang['enter_code'] ?></label>
            <input type="text" name="code" class="form-control" maxlength="4" pattern="\d{4}" required>
        </div>
        <button type="submit" class="btn btn-primary w-100"><?= $lang['verify'] ?></button>
    </form>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
