<?php
require_once 'config/config.php';
require_once 'header.php';

$lang_code = $_SESSION['language'] ?? 'english';
require_once "languages/$lang_code.php";

// التأكد من تسجيل الدخول
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $customer_name = trim($_POST['customer_name']);
$mobile_number = trim($_POST['mobile_number']);
$number_of_people = !empty($_POST['number_of_people']) ? (int)$_POST['number_of_people'] : null;
$number_of_days = !empty($_POST['number_of_days']) ? (int)$_POST['number_of_days'] : null;
$trip_type = trim($_POST['trip_type']);
$request_details = trim($_POST['request_details']);
$status = $_POST['status'];
$first_contact_date = $_POST['first_contact_date'];
$followup_date = $_POST['followup_date'];
$created_by = $_SESSION['user_id'];

    if ($mobile_number !== '') {
   $stmt = $conn->prepare("INSERT INTO customers_followup 
    (customer_name, mobile_number, number_of_people, number_of_days, trip_type, request_details, status, first_contact_date, followup_date, created_by) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt->bind_param("ssiisssssi", $customer_name, $mobile_number, $number_of_people, $number_of_days, $trip_type, $request_details, $status, $first_contact_date, $followup_date, $created_by);

        if ($stmt->execute()) {
            $success = $lang['customer_added_successfully'];
        } else {
            $error = $lang['error_saving_customer'];
        }
    } else {
        $error = $lang['mobile_required'];
    }
}
?>

<div class="main-content p-4" style="flex:1;">
    <div class="card">
        <div class="card-header">
            <h4><?= $lang['add_customer'] ?></h4>
        </div>
        <div class="card-body">
            <?php if ($success): ?>
                <div class="alert alert-success"><?= $success ?></div>
            <?php elseif ($error): ?>
                <div class="alert alert-danger"><?= $error ?></div>
            <?php endif; ?>

            <form method="post">
                <div class="mb-3">
                    <label class="form-label"><?= $lang['customer_name'] ?></label>
                    <input type="text" name="customer_name" class="form-control">
                </div>

                <div class="mb-3">
                    <label class="form-label text-danger">*</label>
                    <label class="form-label"><?= $lang['mobile_number'] ?></label>
                    <input type="text" name="mobile_number" class="form-control" required>
                </div>
<div class="mb-3">
    <label class="form-label"><?= $lang['number_of_people'] ?></label>
    <input type="number" name="number_of_people" class="form-control" min="1">
</div>

<div class="mb-3">
    <label class="form-label"><?= $lang['number_of_days'] ?></label>
    <input type="number" name="number_of_days" class="form-control" min="1">
</div>

<div class="mb-3">
    <label class="form-label"><?= $lang['trip_type'] ?></label>
    <select name="trip_type" class="form-select">
        <option value="package"><?= $lang['trip_package'] ?></option>
        <option value="hajj"><?= $lang['trip_hajj'] ?></option>
        <option value="umrah"><?= $lang['trip_umrah'] ?></option>
    </select>
</div>

                <div class="mb-3">
                    <label class="form-label"><?= $lang['request_details'] ?></label>
                    <textarea name="request_details" class="form-control" rows="3"></textarea>
                </div>

                <div class="mb-3">
                    <label class="form-label"><?= $lang['status'] ?></label>
                    <select name="status" class="form-select">
                        <option value="Waiting"><?= $lang['status_waiting'] ?></option>
                        <option value="Interested"><?= $lang['status_interested'] ?></option>
                        <option value="Not Interested"><?= $lang['status_not_interested'] ?></option>
                        <option value="Purchased"><?= $lang['status_purchased'] ?></option>
                    </select>
                </div>

               <div class="mb-3">
    <label class="form-label"><?= $lang['first_contact_date'] ?></label>
    <input type="date" name="first_contact_date" class="form-control" value="<?= date('Y-m-d') ?>" readonly>
</div>


                <div class="mb-3">
                    <label class="form-label"><?= $lang['followup_date'] ?></label>
                    <input type="date" name="followup_date" class="form-control">
                </div>

                <button type="submit" class="btn btn-primary"><?= $lang['submit'] ?></button>
            </form>
        </div>
    </div>
</div>

<?php require_once 'includes/footer.php'; ?>
