<?php
require_once 'config/config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: auth/login.php");
    exit;
}

$success = '';
$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $customer_name = $_POST['customer_name'];
    $arrival_date = $_POST['arrival_date'];
    $departure_date = $_POST['departure_date'];
    $arrival_notes = $_POST['arrival_notes'];
    $departure_notes = $_POST['departure_notes'];

    // تفاصيل الرحلات
    $arrival_flight = trim($_POST['arrival_flight']);
    $arrival_time = trim($_POST['arrival_time']);
    $departure_flight = trim($_POST['departure_flight']);
    $departure_time = trim($_POST['departure_time']);

    // توليد النص الكامل كما هو مطلوب
    $flight_details = "{$arrival_flight} Arrival {$arrival_time} / {$departure_flight} Departure {$departure_time}";

    $car_type = $_POST['car_type'];
    $extra_notes = $_POST['extra_notes'];
    $pilgrim_phone = $_POST['pilgrim_phone'];
    $persons_count = $_POST['persons_count'];

    $stmt = $conn->prepare("INSERT INTO transport_details 
        (customer_name, arrival_date, departure_date, arrival_notes, departure_notes, flight_details, car_type, extra_notes, pilgrim_phone, persons_count) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("sssssssssi", 
        $customer_name, $arrival_date, $departure_date, $arrival_notes, $departure_notes, 
        $flight_details, $car_type, $extra_notes, $pilgrim_phone, $persons_count);

    if ($stmt->execute()) {
        $success = "تم حفظ بيانات النقل بنجاح";
    } else {
        $error = "حدث خطأ أثناء الحفظ";
    }
}
?>

<?php include 'header.php'; ?>
<div class="main-content p-4" style="flex:1;">

<h2 class="mb-4">إضافة تفاصيل النقل</h2>

<?php if ($success): ?>
    <div class="alert alert-success"><?= $success ?></div>
<?php elseif ($error): ?>
    <div class="alert alert-danger"><?= $error ?></div>
<?php endif; ?>

<form method="POST">

<div class="row mb-3">
    <div class="col-md-4">
        <label class="form-label">اسم المعتمر</label>
        <input type="text" name="customer_name" class="form-control" required>
    </div>
    <div class="col-md-4">
        <label class="form-label">تاريخ الوصول</label>
        <input type="date" name="arrival_date" class="form-control">
    </div>
    <div class="col-md-4">
        <label class="form-label">تاريخ المغادرة</label>
        <input type="date" name="departure_date" class="form-control">
    </div>
</div>

<div class="row mb-3">
    <div class="col-md-6">
        <label class="form-label">ملاحظات الوصول</label>
        <input type="text" name="arrival_notes" class="form-control" placeholder="مثلاً: استقبال مطار جدة">
    </div>
    <div class="col-md-6">
        <label class="form-label">ملاحظات المغادرة</label>
        <input type="text" name="departure_notes" class="form-control" placeholder="مثلاً: توديع مطار جدة">
    </div>
</div>

<!-- تفاصيل الطيران -->
<h5 class="mt-4 mb-3">تفاصيل الرحلات الجوية</h5>
<div class="row mb-3">
    <div class="col-md-3">
        <label class="form-label">رقم رحلة الوصول</label>
        <input type="text" name="arrival_flight" class="form-control" placeholder="مثلاً: XY552">
    </div>
    <div class="col-md-3">
        <label class="form-label">موعد الوصول</label>
        <input type="time" id="arrival_time" name="arrival_time" class="form-control">
        <div class="mt-1">
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('arrival_time','10:30')">10:30</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('arrival_time','12:15')">12:15</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('arrival_time','15:00')">15:00</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('arrival_time','19:35')">19:35</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('arrival_time','20:30')">20:30</button>
        </div>
    </div>

    <div class="col-md-3">
        <label class="form-label">رقم رحلة المغادرة</label>
        <input type="text" name="departure_flight" class="form-control" placeholder="مثلاً: XY551">
    </div>
    <div class="col-md-3">
        <label class="form-label">موعد المغادرة</label>
        <input type="time" id="departure_time" name="departure_time" class="form-control">
        <div class="mt-1">
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('departure_time','12:20')">12:20</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('departure_time','14:15')">14:15</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('departure_time','17:30')">17:30</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('departure_time','19:40')">19:40</button>
            <button type="button" class="btn btn-sm btn-outline-secondary" onclick="setTime('departure_time','21:10')">21:10</button>
        </div>
    </div>
</div>

<script>
function setTime(field, value) {
    document.getElementById(field).value = value;
}
</script>


<div class="row mb-3">
    <div class="col-md-4">
        <label class="form-label">نوع السيارة</label>
        <input type="text" name="car_type" class="form-control" placeholder="مثلاً: سيدان">
    </div>
    <div class="col-md-4">
        <label class="form-label">رقم هاتف المعتمر</label>
        <input type="text" name="pilgrim_phone" class="form-control" placeholder="00962 7 ...">
    </div>
    <div class="col-md-4">
        <label class="form-label">عدد الأشخاص</label>
        <input type="number" name="persons_count" class="form-control" required>
    </div>
</div>

<div class="mb-3">
    <label class="form-label">ملاحظات إضافية</label>
    <textarea name="extra_notes" class="form-control"></textarea>
</div>

<button type="submit" class="btn btn-success">حفظ البيانات</button>
<a href="export_transport_excel.php" class="btn btn-primary">تصدير إلى Excel</a>

</form>

</div>
<?php include 'includes/footer.php'; ?>
