<?php
session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
  <meta charset="UTF-8">
  <title>لوحة التحكم</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css" rel="stylesheet">
  <style>
    body {
      padding-top: 70px;   /* عشان المحتوى ما يختفي تحت الهيدر */
      padding-bottom: 50px; /* عشان المحتوى ما يختفي تحت الفوتر */
    }
    footer {
      font-size: 14px;
    }
  </style>
</head>
<body>

<!-- 🔹 الهيدر الثابت -->
<nav class="navbar navbar-expand-lg navbar-dark bg-success fixed-top">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php">
      <i class="fa-solid fa-kaaba"></i> Umrah Admin
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav"
      aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">
        <li class="nav-item">
          <a class="nav-link" href="index.php"><i class="fa-solid fa-house"></i> الرئيسية</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="requests.php"><i class="fa-solid fa-list"></i> الطلبات</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="add_user.php"><i class="fa-solid fa-user-plus"></i> إضافة مستخدم</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="users.php"><i class="fa-solid fa-users"></i> إدارة المستخدمين</a>
        </li>
      </ul>

      <div class="d-flex">
        <span class="navbar-text text-white me-3">
          مرحباً، <?= htmlspecialchars($_SESSION['username']); ?>
        </span>
        <a href="logout.php" class="btn btn-outline-light btn-sm">
          <i class="fa-solid fa-right-from-bracket"></i> تسجيل الخروج
        </a>
      </div>
    </div>
  </div>
</nav>

<!-- المحتوى -->
<div class="container">
