<?php
require_once '../config/config.php';
session_start();

if (isset($_GET['lang']) && in_array($_GET['lang'], ['english', 'arabic'])) {
    $_SESSION['language'] = $_GET['lang'];
}
$lang_code = $_SESSION['language'] ?? 'english';
require_once "../languages/$lang_code.php";

$error = '';
$email_prefix = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email_prefix = isset($_POST['email']) ? trim($_POST['email']) : '';
    $password     = isset($_POST['password']) ? $_POST['password'] : '';

    $email = $email_prefix . '@safanatours.com';

    if (!$email_prefix) {
        $error = $lang['email_required'];
    } elseif (!$password) {
        $error = $lang['password_required'];
    } else {
        $stmt = $conn->prepare("SELECT id, name, password FROM users WHERE email = ?");
        $stmt->bind_param("s", $email);
        $stmt->execute();
        $stmt->store_result();

        if ($stmt->num_rows === 1) {
            $stmt->bind_result($id, $name, $hashedPassword);
            $stmt->fetch();

            if (password_verify($password, $hashedPassword)) {
                $_SESSION['user_id'] = $id;
                $_SESSION['user_name'] = $name;
                $_SESSION['user_email'] = $email;
                header("Location: ../main.php");
                exit;
            }
        }

        $error = $lang['invalid_credentials'];
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title><?= $lang['login'] ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        .logo {
            display: block;
            margin: 30px auto 10px auto;
            width: 150px;
        }
    </style>
</head>
<body>

<img src="../images/logo.png" alt="<?= $lang['login'] ?>" class="logo">

<div class="container mt-3" style="max-width: 500px;">
    <h2 class="text-center mb-4"><?= $lang['login'] ?></h2>
<div class="text-center mb-3">
    <a href="?lang=english" class="btn btn-sm btn-outline-primary me-2">English</a>
    <a href="?lang=arabic" class="btn btn-sm btn-outline-secondary">العربية</a>
</div>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-3">
            <label class="form-label"><?= $lang['email'] ?></label>
            <div class="input-group">
                <input type="text" name="email" class="form-control" value="<?= htmlspecialchars($email_prefix) ?>" required>
                <span class="input-group-text">@safanatours.com</span>
            </div>
        </div>

        <div class="mb-3">
            <label class="form-label"><?= $lang['password'] ?></label>
            <input type="password" name="password" class="form-control" required>
        </div>

        <button type="submit" class="btn btn-primary w-100"><?= $lang['login_button'] ?></button>
            <div class="text-center mt-3">
        <a href="../forgot_password.php"><?= $lang['forgot_password_question'] ?? 'Forgot your password?' ?></a>
    </div>
    </form>
</div>

<?php include '../includes/footer.php'; ?>
