<?php
require_once 'config/config.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    http_response_code(403);
    exit("Not authorized");
}

if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    http_response_code(400);
    exit("Invalid ID");
}

$id = intval($_GET['id']);

$stmt = $conn->prepare("DELETE FROM transit_visas WHERE id = ?");
$stmt->bind_param("i", $id);

if ($stmt->execute()) {
    echo "Deleted";
} else {
    http_response_code(500);
    echo "Error deleting record";
}
