<?php
require_once 'config/config.php';
session_start();

if (!isset($_SESSION['user_id']) || !isset($_GET['id'])) {
    header("Location: auth/login.php");
    exit;
}

$id = intval($_GET['id']);
$success = '';
$error = '';

// معالجة الحفظ
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_number = $_POST['hotel_confirmation_number'] ?? '';
    $stmt = $conn->prepare("UPDATE vouchers SET hotel_confirmation_number = ? WHERE id = ?");
    $stmt->bind_param("si", $new_number, $id);
    if ($stmt->execute()) {
        $success = $lang['updated_successfully'];
    } else {
        $error = $lang['update_failed'];
    }
}

// جلب البيانات الحالية
$stmt = $conn->prepare("SELECT hotel_confirmation_number FROM vouchers WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$result = $stmt->get_result();
$data = $result->fetch_assoc();
$current_number = $data['hotel_confirmation_number'] ?? '';
?>

<?php include 'header.php'; ?>
<div class="main-content p-4" style="flex:1;">
    <h3 class="mb-4"><?= $lang['edit_conf_number'] ?></h3>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php elseif ($success): ?>
        <div class="alert alert-success"><?= $success ?></div>
    <?php endif; ?>

    <form method="POST">
        <div class="mb-3">
            <label class="form-label"><?= $lang['hotel_confirmation_number'] ?></label>
            <input type="text" name="hotel_confirmation_number" value="<?= htmlspecialchars($current_number) ?>" class="form-control">
        </div>
        <button type="submit" class="btn btn-success"><?= $lang['save'] ?></button>
        <a href="view_voucher.php" class="btn btn-secondary"><?= $lang['back'] ?? 'Back' ?></a>
    </form>
</div>
<?php include 'includes/footer.php'; ?>
